package app.firezone.synk.network.Activities;



import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.widget.Toast;

import com.google.firebase.database.FirebaseDatabase;
import com.squareup.picasso.Picasso;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.Adapter.BgmiWinnerAdapter;
import app.firezone.synk.network.Adapter.TopWinnerAdapter;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivityBgmiWinnersBinding;
import app.firezone.synk.network.model.Winner_Model;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class BgmiActivity extends AppCompatActivity {


    ActivityBgmiWinnersBinding binding;
    BgmiWinnerAdapter winnerAdapter;

    TopWinnerAdapter myAdapter;

    ArrayList<Winner_Model> topWinnerModels = new ArrayList<>();


    FirebaseDatabase database;

    String gameName, matchId;

    Dialog dialog;

    @SuppressLint("MissingInflatedId")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding =  ActivityBgmiWinnersBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());


        binding.backArrow.setOnClickListener(v -> finish());

        database = FirebaseDatabase.getInstance();

        topWinnerModels = new ArrayList<Winner_Model>();

        matchId = getIntent().getStringExtra("matchid");
        gameName = getIntent().getStringExtra("gamename");

        String date = getIntent().getStringExtra("date");
        String time = getIntent().getStringExtra("time");
        String matchno = getIntent().getStringExtra("matchno");
        String images = getIntent().getStringExtra("images");

        Picasso.get().
                load(images)
                .placeholder(R.drawable.loading_img)
                .into(binding.imageView5);

        binding.dateTxt.setText(date);
        binding.timeTxt.setText(time);
        binding.gameName.setText(gameName +" "+ matchno);


        dialog = new Dialog(this);
        dialog.setContentView(R.layout.loading_dialog);

        if (dialog.getWindow() !=null){

            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCancelable(true);
        }

        dialog.show();



        LinearLayoutManager layoutManager2 = new LinearLayoutManager(BgmiActivity.this);
        binding.topWinersRecy.setLayoutManager(layoutManager2);
        myAdapter = new TopWinnerAdapter(topWinnerModels, BgmiActivity.this);
        binding.topWinersRecy.setAdapter(myAdapter);

        MyApi myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
        myApi.fetchResultMatchUserData(Long.parseLong(matchId)).enqueue(new Callback<ArrayList<Winner_Model>>() {
            @Override
            public void onResponse(Call<ArrayList<Winner_Model>> call, Response<ArrayList<Winner_Model>> response) {
                dialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    topWinnerModels.clear();

                    // Filter players with playerStatus = "Winner"
                    for (Winner_Model winner : response.body()) {
                        if ("Winner".equalsIgnoreCase(winner.getPlayerStatus())) {
                            topWinnerModels.add(winner);
                        }
                    }

                    if (topWinnerModels.isEmpty()) {
                        Toast.makeText(BgmiActivity.this, "No winners found", Toast.LENGTH_SHORT).show();
                    }

                    myAdapter.notifyDataSetChanged();
                } else {
                    Toast.makeText(BgmiActivity.this, "No winners found", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<Winner_Model>> call, Throwable t) {
                dialog.dismiss();
                Toast.makeText(BgmiActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });


        LinearLayoutManager layoutManager = new LinearLayoutManager(BgmiActivity.this);
        binding.winersRecy.setLayoutManager(layoutManager);

        winnerAdapter = new BgmiWinnerAdapter(topWinnerModels, BgmiActivity.this);
        binding.winersRecy.setAdapter(winnerAdapter);

        myApi.fetchResultMatchUserData(Long.parseLong(matchId)).enqueue(new Callback<ArrayList<Winner_Model>>() {
            @Override
            public void onResponse(Call<ArrayList<Winner_Model>> call, Response<ArrayList<Winner_Model>> response) {
                if (response.isSuccessful() && response.body() != null) {
                    topWinnerModels.clear();
                    topWinnerModels.addAll(response.body());

                    // Sort the list in ascending order by prize
                    Collections.sort(topWinnerModels, new Comparator<Winner_Model>() {
                        @Override
                        public int compare(Winner_Model w1, Winner_Model w2) {
                            return Integer.compare(Integer.parseInt(w1.getPrize()), Integer.parseInt(w2.getPrize()));
                        }
                    });

                    // Reverse the list to get the highest prize winners first
                    Collections.reverse(topWinnerModels);

                    // Notify the adapter that data has changed
                    winnerAdapter.notifyDataSetChanged();
                } else {
                    Toast.makeText(BgmiActivity.this, "No winners found", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<Winner_Model>> call, Throwable t) {
                Toast.makeText(BgmiActivity.this, "Data Not Load: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });

    }
}